unit Odgridb;

interface
uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
Forms, Dialogs, Grids, DBGrids, DB, DBTables, ExtCtrls, stdctrls, buttons,
ODshape, dbctrls;

Type

    TODGridBarLanguage = (odgbEnglish,odgbFrench);

    TODGridBarDataLink = class;

    TODGridBar = Class (TCustomPanel)
                 private
                 fedit : tedit;
                 spFind,
                 spNext : TSpeedButton;
                 Fcombo:TCombobox;
                 fDAtalink: TODGridBarDataLink;
                 FcbAW, Fcbcase : TCheckBox;
                 Fsh : TODShape;
                 Flang : TODGridBarLanguage;
                 FEnCt : Boolean;
                 FonSize,
                 FonField : TNotifyEvent;
                 fstatinactive,
                 fstatbrowse,
                 fstatedit,
                 fstatinsert:tcolor;
                 

                 function GetDataSource: TDataSource;
                 procedure SetDataSource(Value: TDataSource);
                 procedure SetLang(value:TodGridBarLanguage);
                 Procedure SetEnCt(value:Boolean);
                 procedure SetComboWidth(value:integer);
                 procedure SetEditWidth(value:integer);
                 function  GetEditWidth:integer;
                 function  GetComboWidth:integer;
                 procedure SetStatusWidth(value:integer);
                 procedure SetStatusHeight(value:integer);
                 Function  GetStatusWidth:integer;
                 Function  GetStatusHeight:integer;
                 procedure Fontchanged(sender:tobject);
                 procedure SetCase(Value:Boolean);
                 procedure SetAW(value:boolean);
                 Function  GetCase:Boolean;
                 Function  GetAW:Boolean;
                 Function  GetActiveField:String;
                 Procedure SetOnFIeld(value:TnotifyEvent);
                 procedure SetCpr(value:string);
                 function  GetCpr:string;
                 procedure SetStatInactive(value:tcolor);
                 procedure SetStatBrowse(value:Tcolor);
                 procedure SetStatEdit(value:Tcolor);
                 procedure SetStatInsert(value:Tcolor);


                 protected
                 procedure Notification(acomponent:Tcomponent;operation:toperation); override;
                 procedure DataChanged; dynamic;
                 procedure EditingChanged; dynamic;
                 procedure ActiveChanged; dynamic;
                 procedure Loaded; override;
                 procedure ComboBoxChange(Sender: TObject); dynamic;
                 Function  GetFieldNumber(const s:string):integer; dynamic;
                 procedure FindClick(sender:tobject); dynamic;
                 procedure NextClick(sender:tobject); dynamic;

                 property  EnabledCt:boolean read Fenct write SetenCt;
                 procedure WMSize(var Message: TWMSize);  message WM_SIZE;
                 function FindData(from1st:boolean): Boolean; dynamic;

                 public
                 constructor create(aowner:Tcomponent); override;
                 Destructor Destroy; override;

                 published
                 property align;
                 property BevelInner;
                 property BevelOuter default bvlowered;
                 property BevelWidth;
                 Property BorderStyle;
                 Property BorderWidth;
                 property color;
                 property height default 34;
                 property HelpContext;
                 property Left;
                 property Parentcolor;
                 property ParentSHowHint;
                 property ShowHint;
                 property taborder;
                 property TabStop;
                 property Top;
                 Property Tag;
                 property Visible;
                 property Width default 508;
                 property font;
                 property parentfont;

                 property DataSource: TDataSource read GetDataSource write SetDataSource;
                 property Language : TODGridBarLanguage read Flang write SetLang default odgbEnglish;
                 property EditWidth:integer read GetEditWidth write SetEditWidth;
                 property ComboWidth:integer read GetComboWidth write SetComboWidth;
                 property StatusWidth:integer read GetStatusWidth write SetStatusWidth;
                 property StatusHeight:integer read GetStatusHeight write SetStatusHeight;
                 property CaseSensitive:Boolean read GetCase write SetCase default false;
                 property Anywhere:boolean read GetAW write SetAW default true;
                 property ActiveFieldName:String read GetActiveField;
                 property StatusColorInactive:tcolor read fstatInactive write setStatInactive default clgray;
                 property StatusColorBrowse:Tcolor read fstatBrowse write SetStatBrowse default clLime;
                 property StatusColorEdit:Tcolor read fstatEdit write setStatEdit default clRed;
                 property StatusColorInsert:Tcolor read FstatInsert write setStatInsert default clYellow;

                 property OnSizeChanged:TnotifyEvent read FonSize write FonSize;
                 property OnFieldChanged:TNotifyEvent read FOnField write SetOnField;

                 property __CopyRights:String read getcpr write setcpr;
                 end;

{ TODGridBarDataLink }

  TODGridBarDataLink = class(TDataLink)
  private
    FGridBar: TODGridBar;
  protected
    procedure EditingChanged; override;
    procedure DataSetChanged; override;
    procedure ActiveChanged; override;
  public
    constructor Create(AGB: TOdGridBar);
    destructor Destroy; override;
  end;


Procedure Register;


implementation

Procedure Register;
begin
 RegisterComponents('DBDiv',[TODGridBar]);
end;


{$R ODGRIDB.R16 }





Const
     Copyrights = 'V 1.2 2/97  Olivier Dahan. 100531,163';

     MaxCaptions = 13;
     _Anywhere = 1;
     _CaseSens = 2;
     _Inactive = 3;
     _Browse   = 4;
     _Edit     = 5;
     _Insert   = 6;
     _hedit    = 7;
     _hfind    = 8;
     _hnext    = 9;
     _haw      = 10;
     _hcase    = 11;
     _hcombo   = 12;
     _hstate   = 13;
     _Captions : array[TODGridBarLanguage,1..MaxCaptions] of integer =
      ( (100,101,102,103,104,105,1100,1101,1102,1103,1104,1105,1106),
        (200,201,202,203,204,205,1200,1201,1202,1203,1204,1205,1206) );
     kinactive : string [30] = 'Inactive';
     kBrowse   : string [30] = 'Browse';
     kEdit     : string [30] = 'Edit';
     kInsert   : string [30] = 'Insert';

     MiniWidth  = 508;
     MiniHeight = 34;

Constructor TODGridBar.Create(Aowner:Tcomponent);
begin
 Inherited create(aowner);
 visible:=false;
 controlstyle:=[cscapturemouse,csclickevents,csopaque];
 height := MiniHeight;
 BevelOuter:=bvLowered;
 Caption:='';
 width := MiniWidth;
 Fenct := true;
 parentshowhint:=true;

 font.name:='arial';
 font.size:=8;

 fstatinactive:=clgray;
 fstatbrowse:=cllime;
 fstatedit:=clred;
 fstatinsert:=clyellow;

 fedit:=tedit.create(self);
 with fedit do
 begin parent:=self;
       text:='';
       left:=6;
       top:=6;
       width:=116;
       parentfont:=true;
       parentshowhint:=true;
 end;

 spFind:=TspeedButton.Create(self);
 with spfind do
 begin parent:=self;
       left:= 126;
       top:=4;
       Glyph.handle:=LoadBitmap(hInstance, 'FINDFIRST');
       NumGlyphs:=2;
       parentfont:=true;
       parentshowhint:=true;
       OnClick:=FindClick;
 end;

 spnext:=tspeedbutton.create(self);
 with spnext do
 begin parent:=self;
       left:=155;
       top:=4;
       Glyph.handle:=LoadBitmap(hInstance, 'FINDNEXT');
       NumGlyphs:=2;
       parentfont:=true;
       parentshowhint:=true;
       OnClick:=NextClick;
 end;

 FcbAW:=TCheckBox.Create(self);
 with FcbAW do
 begin parent:=self;
       Left := 183;
       Top := 2;
       Width := 90;
       Height := 17;
       State := cbChecked;
       parentfont:=true;
       parentshowhint:=true;
 end;

 FcbCase:=TCheckBox.create(self);
 with fcbCase do
 begin parent:=self;
       Left := 183;
       Top := 15;
       Width := 90;
       Height := 17;
       parentfont:=true;
       parentshowhint:=true;
 end;

 Fcombo:=TComboBox.Create(self);
 with Fcombo do
 begin parent:=self;
       style:=csDropDownList;
       left:=275;
       top:=6;
       width:=144;
       OnChange:=ComboboxChange;
       sorted:=true;
       parentfont:=true;
       parentshowhint:=true;
 end;

 Fsh := TODSHape.Create(self);
 with fsh do
 begin parent:=self;
       Left := 424;
       Top := 9;
       Width := 78;
       Height := 16;
       Brush.Color := clgray;
       ShowCaption := True;
       Shapecaption := 'Inactive';
       parentfont:=true;
       Font.Style := [fsBold];
       BlinkInterval := 300;
       parentshowhint:=true;
 end;

 Language := odgbEnglish;
 Fdatalink:=TODGridBarDataLink.Create(self);
 Font.Onchange := FontChanged;
 visible:=true;
end;

Destructor TODGridBar.Destroy;
begin
DataSource:=Nil;
Font.Onchange:=Nil;
Fdatalink.free;
Fdatalink:=nil;
fcbcase.free; fcbcase:=nil;
fcbaw.free; fcbaw:=nil;
Fedit.Free; fedit:=nil;
spfind.free; spfind:=nil;
spnext.free; spnext:=nil;
fcombo.free; fcombo:=nil;
fsh.free; fsh:=nil;
inherited destroy;
end;

procedure TODGridBar.SetLang(value:TodGridBarLanguage);
begin
if (csDestroying in ComponentState) then exit;
Flang:=Value;
FcbAW.caption     := LoadStr(_Captions[Flang,_Anywhere]);
FcbCase.caption   := LoadStr(_Captions[Flang,_CaseSens]);
kinactive         := LoadStr(_Captions[Flang,_inactive]);
kbrowse           := LoadStr(_Captions[Flang,_browse]);
kedit             := LoadStr(_Captions[Flang,_edit]);
kinsert           := LoadStr(_Captions[Flang,_insert]);
fedit.hint        := LoadStr(_Captions[Flang,_hedit]);
spfind.hint       := LoadStr(_Captions[Flang,_hfind]);
spnext.hint       := LoadStr(_Captions[Flang,_hnext]);
fcbaw.hint        := LoadStr(_Captions[Flang,_haw]);
fcbcase.hint      := LoadStr(_Captions[Flang,_hcase]);
fcombo.hint       := LoadStr(_Captions[Flang,_hcombo]);
fsh.hint          := LoadStr(_Captions[Flang,_hstate]);
EditingChanged;
end;

Procedure TODGridBar.SetEnCt(value:Boolean);
begin
if (csDestroying in ComponentState) then exit;
 if value<>FenCt then
  begin
   FenCt:=value;
   if fedit<>nil     then Fedit.enabled:=FenCt;
   if spfind<>nil    then spfind.enabled:=FenCt;
   if spnext<>nil    then spNext.enabled:=FenCt;
   if fcbaw<>nil     then FcbAw.enabled:=Fenct;
   if fcbcase<>nil   then FcbCase.enabled:=Fenct;
   if fcombo<>nil    then Fcombo.enabled:=Fenct;
  end;
end;

procedure TODGridBar.Notification(acomponent:Tcomponent;operation:toperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;
  if datasource=nil then EnabledCt:=false;
 end;

procedure TODGridBar.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
  if not (csLoading in ComponentState) then
    ActiveChanged;
end;

function TODGridBar.GetDataSource: TDataSource;
begin
if fdatalink<>nil then Result := FDataLink.DataSource else result:=nil;
end;

procedure TODGridBar.Loaded;
begin
  inherited Loaded;
  ActiveChanged;
end;


procedure TODGridBar.EditingChanged;
begin
if (csDestroying in ComponentState) then exit;
fsh.blink:=false;
fsh.shapecaption:=kInactive;
fsh.brush.color:=fstatinactive;
if (componentState=[]) and
(Fdatalink<>nil) and (Fdatalink.dataset<>nil) then
 begin
 case Fdatalink.DataSet.State of
 dsedit:with fsh do begin shapecaption:=kEdit; brush.Color:=fstatedit; end;
 dsbrowse:with fsh do begin shapecaption:=kBrowse; brush.Color:=fstatbrowse; end;
 dsinsert:with fsh do begin shapecaption:=kInsert; brush.Color:=fstatinsert; blink:=true; end;
 end;
 if Fdatalink.Dataset.state in [dsedit,dsbrowse,dsinsert] then EnabledCt:=True
                                                          else EnabledCt:=false;
 end else EnabledCt:=false;
 end;

procedure TODGridBar.ActiveChanged;
var i:integer;
begin
if (csDestroying in ComponentState) then exit;
Fcombo.items.clear; EnabledCt:=false; fedit.text:='';
If FDataLink.dataset<>Nil then
 begin
  For i:=0 to Fdatalink.Dataset.Fieldcount-1 do
   If (Fdatalink.Dataset.Fields[i].visible) and
      (Fdatalink.DataSet.Fields[i].DataType in
      [ftString, ftSmallint, ftInteger, ftWord, ftFloat,
       ftCurrency, ftBCD, ftDate, ftTime, ftDateTime,ftmemo]) then
    Fcombo.items.add(Fdatalink.Dataset.Fields[i].DisplayLabel);
    EnabledCt:=true;
 end;
if Fcombo.items.count>0 then Fcombo.itemIndex:=0;
DataChanged;
EditingChanged;
If Assigned(FonField) then FOnField(self);
end;

procedure TODGridBar.DataChanged;
begin
{ * }
end;

procedure TODGridBar.ComboBoxChange(Sender: TObject);
begin
if (csDestroying in ComponentState) then exit;
fedit.text:='';
If Assigned(FonField) then FonField(self);
end;

procedure TODGridBar.WMSize(var Message: TWMSize);
var h,w,i,c:integer;
begin
if (message.width>0) and (message.height>0) then
 begin
 w:=message.width;
 h:=message.height;
 end else
 begin
 w:=width;
 h:=height;
 end;
 SetBounds(left,top,w,h);
w:=fedit.width+spfind.width+spnext.width+fcbcase.width+fcombo.width+fsh.width;
h:=width-w-10;
i:=h div 5;
fedit.left:=5;
spfind.left:=fedit.left+fedit.width+i;
spnext.left:=spfind.left+spfind.width+i;
fcbAW.left:=spnext.left+spnext.width+i;
fcbcase.left:=fcbaw.left;
fcombo.left:=fcbcase.left+fcbcase.width+i;
fsh.left:=fcombo.left+fcombo.width+i;
h:=(height-fedit.height) div 2; fedit.top:=h; fcombo.top:=h;
h:=(height-fsh.height) div 2; fsh.top:=h;
spfind.top:=(height-spfind.height) div 2;
spnext.top:=spfind.top;
h:=(height-((fcbcase.top+fcbcase.height)-fcbaw.top)) div 2;
i:=h-fcbaw.top;
fcbcase.top:=fcbcase.top+i;
fcbaw.top:=fcbaw.top+i;
If Assigned(FOnSize) then FOnSize(Self);
end;

Procedure TODGridBar.SetEditWidth(value:integer);
var i:integer;
begin
 if value<>fedit.width then
  begin
   i:=value-fedit.width;
   fedit.width:=value;
   (* width:=width+i; *) width:=width+1; width:=width-1;
  end;
end;

Procedure TODGridBar.SetComboWidth(value:integer);
var i:integer;
begin
 if value<>fcombo.width then
  begin
   i:=value-fcombo.width;
   fcombo.width:=value;
   (* width:=width+i; *) width:=width+1; width:=width-1;
  end;
end;

Procedure TODGridBar.SetStatusWidth(value:integer);
var i:integer;
begin
 if value<>fsh.width then
  begin
   i:=value-fsh.width;
   fsh.width:=value;
   (* width:=width+i; *) width:=width+1; width:=width-1;
  end;
end;

Procedure TODGridBar.SetStatusHeight(value:integer);
var i:integer;
begin
 if value<>fsh.height then
  begin
   i:=value-fsh.height;
   fsh.height:=value;
   width:=width+1; width:=width-1; { force fsh placement }
  end;
end;



Function TODGridBar.GetEditWidth:integer;
begin result:=Fedit.width; end;

Function TODGridBar.GetComboWidth:integer;
begin result:=fcombo.width; end;

Function TODGridBar.GetStatusWidth:integer;
begin result:=fsh.width; end;

Function TODGridBar.GetStatusHeight:integer;
begin result:=fsh.height; end;

procedure TODGridBar.Fontchanged(sender:tobject);
var m:twmsize;
begin
if (csDestroying in ComponentState) then exit;
fedit.font.assign(font);
fcbaw.font.Assign(font);
fcbcase.font.assign(font);
fcombo.font.assign(font);
fsh.font.assign(font);
fsh.font.style:=fsh.font.style+[fsbold];
m.height:=0; m.width:=0;
wmsize(m);
end;

Procedure TODGridBar.SetCase(value:boolean);
begin fcbcase.checked:=value; end;

Procedure TODGridBar.SetAW(value:boolean);
begin fcbAW.checked:=value; end;

Function TODGridBar.GetCase:boolean;
begin result:=fcbcase.checked; end;

Function TODGridBar.GetAW:boolean;
begin result:=fcbAW.checked; end;


Function TODGridBar.GetFieldNumber(const s:string):integer;
var i:integer;
begin
result:=-1;
if (csDestroying in ComponentState) then exit;
if (Fdatalink=nil) or (Fdatalink.dataset=nil) or (Fdatalink.dataSet.state=dsinactive)
 then exit;
for i:=0 to Fdatalink.DataSet.FieldCount-1 do
 if uppercase(s)=uppercase(Fdatalink.Dataset.Fields[i].DisplayLabel) then
    begin Result:=i; break; end;
end;

Function TODGridBar.GetActiveField:String;
var i:integer;
begin
 result:='';
 if (csDestroying in ComponentState) then exit;
 i:=GetFieldNumber(fcombo.text);
 if i<0 then exit;
 Result:=Fdatalink.Dataset.Fields[i].FieldName;
end;

Procedure TODGridBar.SetOnField(value:TnotifyEvent);
begin
Fonfield:=value;
If Assigned(FonField) then FOnField(self);
end;


function TODGridBar.FindData(from1st:boolean): Boolean;
var
  bm : TBookMark;
  fnd : Boolean;
  fn  : integer;
  ct  : string;

  Function CheckData:Boolean;
  var st:string; p:Pchar; bs:TblobStream; p2:array[0..255] of char;
  begin
  result:=false;
  if Fdatalink.dataset.fields[fn].datatype=ftmemo then
   begin
    Getmem(p,32768);
    try
    FillChar(p^,32768,0);
    bs := TBlobStream.Create(Tblobfield(fdatalink.dataset.Fields[fn]),BmRead);
     try
     if bs.Seek(0, 2)>32768 then
      begin { long text memo, not managed }
      end else                  
      begin
      bs.seek(0,0);
      bs.Read(p^,32768);
      end;
     finally bs.free; end;
      if not fcbcase.checked then StrUpper(P);
      strPcopy(p2,ct);
      result:= StrPos(P, P2 )<>nil;
    finally  Freemem(P,32768); end;
   end else
   begin
   if fcbcase.checked then st:=fdatalink.dataset.fields[fn].AsString
                      else st:=uppercase(fdatalink.dataset.fields[fn].AsString);
   if fcbaw.checked then result:=pos(ct,st)>0
                    else result:=copy(st,1,length(ct))=ct;
   end;
  end;

begin
  result := FALSE;
  fn     := GetFieldNumber(Fcombo.text);
  if fn<0 then exit;
  if fcbcase.checked then ct:=fedit.text else ct:=uppercase(fedit.text);

  if (fdatalink<>nil) and (fDatalink.dataset<>nil)
  and (fDatalink.dataset.active)
  then begin

    bm := Fdatalink.DataSet.GetBookMark;
    fdatalink.DataSet.DisableControls;
    if (From1st) then  { if SearchFromStart }
      fdatalink.DataSet.First else      { then rewind table }
      begin
      if not fdatalink.DataSet.Eof then
         fdatalink.DataSet.Next;
      end;

    WHILE NOT (fdatalink.DataSet.EoF) DO BEGIN
      result:=CheckData;

      IF (result) THEN
        Break;

      Fdatalink.DataSet.Next;
    END;

    IF (NOT result) THEN
      Fdatalink.DataSet.GotoBookMark(bm);

    fdatalink.DataSet.EnableControls;
    fdatalink.DataSet.FreeBookMark(bm);
  end;
end;

procedure TODGridBar.FindClick(sender:tobject);
begin
 if not findData(true) then messagebeep(MB_ICONEXCLAMATION);
end;

procedure TODGridBar.NextClick(sender:tobject);
begin
 if not findData(false) then messagebeep(MB_ICONEXCLAMATION);
end;

Procedure TODGridBar.SetCpr(value:string);
begin
end;

Function TODGridBar.GetCpr:String;
begin result:=copyrights; end;

procedure TODGridBar.SetStatInactive(value:tcolor);
begin
 if value<>fstatInactive then
  begin
   fstatinactive:=value;
   editingchanged;
  end;
end;

procedure TODGridBar.SetStatbrowse(value:tcolor);
begin
 if value<>fstatbrowse then
  begin
   fstatbrowse:=value;
   editingchanged;
  end;
end;

procedure TODGridBar.SetStatEdit(value:tcolor);
begin
 if value<>fstatEdit then
  begin
   fstatEdit:=value;
   editingchanged;
  end;
end;

procedure TODGridBar.SetStatInsert(value:tcolor);
begin
 if value<>fstatInsert then
  begin
   fstatinsert:=value;
   editingchanged;
  end;
end;


{ TODGridBarDataLink }

constructor TODGridBarDataLink.Create(AGB: TODGridBar);
begin
  inherited Create;
  FGridBar := AGB;
end;

destructor TODGridBarDataLink.Destroy;
begin
  Fgridbar := nil;
  inherited Destroy;
end;

procedure TODGridBarDataLink.EditingChanged;
begin
  if FGridbar <> nil then FGridbar.EditingChanged;
end;

procedure TODGridBarDataLink.DataSetChanged;
begin
  if FGridBar <> nil then FGridBar.DataChanged;
end;

procedure TODGridBarDataLink.ActiveChanged;
begin
  if FGridBar <> nil then FGridBar.ActiveChanged;
end;


end.











